function xdot = extremumswarming_no_derivative(t, x)

global M xp0 yp0 xs ys dt;
global a b c;
global w;


% variable matrix
% A1 A2 A3 T
% x        xt
% y        yt

z = zeros(3, M+1);
zdot = zeros(3, M+1);

for i=1:M+1,
  z(:, i) = x(3*(i-1)+1:3*i);
end;

%%%%%
% target
tar=z(1:2,M+1);
tar_dot(1)=0;%.01*cos(0.02*t)+3;
tar_dot(2)=0;%.01*sin(0.01*t);
%tar_dot(1)=.1;%0.25;
%tar_dot(2)=sin(0.01*t);%sin(0.25*t);
%tar_dot(1)=.5;%0.25;
%tar_dot(2)=sin(0.05*t);%sin(0.25*t);

for i=1:M
    xp(i)=z(1,i);%xp2=z(1,2);xp3=z(1,3);
    yp(i)=z(2,i);%yp2=z(2,2);yp3=z(2,3);
    eta(i)=z(3,i);%eta(2)=z(3,2);eta(3)=z(3,3);
end

for i=1:M
    vx(i)=-(1/dt)*(xp0(i)-xs(i));
    vy(i)=-(1/dt)*(yp0(i)-ys(i));
end

% vehicle dyanmics (pointmass + high pass filter)

for i=1:M
   % velocity, high pass filter
  zdot(1:3,i) = [vx(i);vy(i);0];    
end;


% Target dynamics
zdot(1:2, M+1) = tar_dot(:);

% Return a column vector
for i=1:M+1,
  xdot(3*(i-1)+1:3*i) = zdot(:, i);
end;
xdot = xdot';  %'

 
 